/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.power.factory.condition;

import io.github.apace100.origins.Origins;
import io.github.apace100.origins.power.factory.condition.ConditionFactory;
import io.github.apace100.origins.registry.ModRegistriesArchitectury;
import io.github.apace100.origins.util.SerializableData;
import io.github.apace100.origins.util.SerializableDataType;
import java.util.List;
import net.minecraft.fluid.FluidState;
import net.minecraft.tags.ITag;

public class FluidConditions {
    public static void register() {
        FluidConditions.register(new ConditionFactory<FluidState>(Origins.identifier("constant"), new SerializableData().add("value", SerializableDataType.BOOLEAN), (data, fluid) -> data.getBoolean("value")));
        FluidConditions.register(new ConditionFactory<FluidState>(Origins.identifier("and"), new SerializableData().add("conditions", SerializableDataType.FLUID_CONDITIONS), (data, fluid) -> ((List)data.get("conditions")).stream().allMatch(condition -> condition.test(fluid))));
        FluidConditions.register(new ConditionFactory<FluidState>(Origins.identifier("or"), new SerializableData().add("conditions", SerializableDataType.FLUID_CONDITIONS), (data, fluid) -> ((List)data.get("conditions")).stream().anyMatch(condition -> condition.test(fluid))));
        FluidConditions.register(new ConditionFactory<FluidState>(Origins.identifier("empty"), new SerializableData(), (data, fluid) -> fluid.func_206888_e()));
        FluidConditions.register(new ConditionFactory<FluidState>(Origins.identifier("still"), new SerializableData(), (data, fluid) -> fluid.func_206889_d()));
        FluidConditions.register(new ConditionFactory<FluidState>(Origins.identifier("in_tag"), new SerializableData().add("tag", SerializableDataType.FLUID_TAG), (data, fluid) -> fluid.func_206884_a((ITag)data.get("tag"))));
    }

    private static void register(ConditionFactory<FluidState> conditionFactory) {
        ModRegistriesArchitectury.FLUID_CONDITION.register(conditionFactory.getSerializerId(), () -> conditionFactory);
    }
}

